<?php
require_once 'config.php';
if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}
require_once 'header.php';

$user_id = $_SESSION['user_id'];

// Get user information
$query = "SELECT * FROM users WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Get user balance
$user_balance = $user['balance'] ?? 0;

// Get user transactions
$query = "SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 5";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $user_id);
$stmt->execute();
$transactions = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Get user orders
$query = "SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC LIMIT 5";
$stmt = $conn->prepare($query);
$stmt->bind_param('i', $user_id);
$stmt->execute();
$orders = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
?>

<div class="container py-4">
    <!-- معلومات المستخدم -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card bg-dark text-white border-secondary">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h4 class="mb-3">مرحباً <?php echo htmlspecialchars($user['username']); ?></h4>
                            <div class="row">
                                <div class="col-md-6">
                                    <p class="mb-2"><i class="bi bi-envelope me-2"></i> البريد الإلكتروني: <?php echo htmlspecialchars($user['email']); ?></p>
                                    <p class="mb-2"><i class="bi bi-calendar me-2"></i> تاريخ التسجيل: <?php echo date('Y-m-d', strtotime($user['created_at'])); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <p class="mb-2"><i class="bi bi-person me-2"></i> اسم المستخدم: <?php echo htmlspecialchars($user['username']); ?></p>
                                    <p class="mb-2"><i class="bi bi-clock-history me-2"></i> آخر تسجيل دخول: <?php echo date('Y-m-d H:i', strtotime($user['last_login'] ?? $user['created_at'])); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 text-end">
                            <div class="d-flex flex-column h-100 justify-content-center">
                                <h5 class="mb-2">رصيدك الحالي</h5>
                                <h2 class="mb-3"><?php echo number_format($user_balance, 2); ?> $</h2>
                                <a href="add-balance.php" class="btn btn-primary" style="background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%); border: none;">
                                    <i class="bi bi-plus-circle me-1"></i> إضافة رصيد
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- آخر المعاملات -->
        <div class="col-md-6 mb-4">
            <div class="card bg-dark text-white border-secondary h-100">
                <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">آخر المعاملات</h5>
                    <a href="transactions_user.php" class="btn btn-sm btn-primary">عرض الكل</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-dark table-striped">
                            <thead>
                                <tr>
                                    <th>النوع</th>
                                    <th>المبلغ</th>
                                    <th>التاريخ</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($transactions)): ?>
                                    <?php foreach ($transactions as $transaction): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($transaction['type']); ?></td>
                                        <td><?php echo number_format($transaction['amount'], 2); ?> $</td>
                                        <td><?php echo date('Y-m-d H:i', strtotime($transaction['created_at'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $transaction['status'] === 'completed' ? 'success' : 'warning'; ?>">
                                                <?php echo $transaction['status'] === 'completed' ? 'مكتمل' : 'قيد الانتظار'; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد معاملات</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- آخر الطلبات -->
        <div class="col-md-6 mb-4">
            <div class="card bg-dark text-white border-secondary h-100">
                <div class="card-header bg-dark border-secondary d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">آخر الطلبات</h5>
                    <a href="orders.php" class="btn btn-sm btn-primary">عرض الكل</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-dark table-striped">
                            <thead>
                                <tr>
                                    <th>الخدمة</th>
                                    <th>الكمية</th>
                                    <th>التاريخ</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($orders)): ?>
                                    <?php foreach ($orders as $order): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($order['service_name']); ?></td>
                                        <td><?php echo htmlspecialchars($order['amount']); ?></td>
                                        <td><?php echo date('Y-m-d H:i', strtotime($order['created_at'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php 
                                                echo match($order['status']) {
                                                    'completed' => 'success',
                                                    'pending' => 'warning',
                                                    'cancelled' => 'danger',
                                                    default => 'secondary'
                                                };
                                            ?>">
                                                <?php 
                                                echo match($order['status']) {
                                                    'completed' => 'مكتمل',
                                                    'pending' => 'قيد الانتظار',
                                                    'cancelled' => 'ملغي',
                                                    default => 'غير معروف'
                                                };
                                                ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد طلبات</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 